//----------------------------------------------------------------------------//
//- CadArtikelUebersicht.pas -------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dialog zum hinzufgen und bearbeiten von Artikeldaten                      //
//----------------------------------------------------------------------------//

unit CadArtikelUebersicht;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, CafAnbieterUebersicht, StdCtrls,
  CafArtikelUebersicht, Menus, ComCtrls, CaoPersonenListe, CamConst,
  CaoArtikelListe, CaoBoersenInfo;

//------------------------------------------------------------------------------

type
  TCaDlgArtikelUebersicht = class(TCaDlgBaseDialog)
    m_GrpAnbieter             : TGroupBox;
    m_FrmAnbieterUebersicht   : TFrmAnbieterUebersicht;
    m_GrpArtikel              : TGroupBox;
    m_FrmArtikelUebersicht    : TFrmArtikelUebersicht;
    m_BtnNeu                  : TButton;
    m_BtnKopieren             : TButton;
    m_BtnBearbeiten           : TButton;
    m_BtnLoeschen             : TButton;
    m_BtnEtikettenDrucken     : TButton;

    //--------------------------------------------------------------------------

    procedure FormShow           (Sender: TObject);
    procedure FormCreate         (Sender: TObject);
    procedure FormDestroy        (Sender: TObject);
    procedure BtnNeuClick        (Sender: TObject);
    procedure BtnKopierenClick   (Sender: TObject);
    procedure BtnBearbeitenClick (Sender: TObject);
    procedure BtnLoeschenClick   (Sender: TObject);
    procedure FormClose          (Sender: TObject; var Action: TCloseAction);

  //----------------------------------------------------------------------------

  private
    m_obAnbieterListe: TCaoPersonenListe;
    m_obArtikelListe : TCaoArtikelListe;
    m_obBoersenInfo  : TCaoBoersenInfo;

    //------------------------------------------------------------------------------

    procedure PrvSetArtikelStatus;
    procedure PrvUpdateArtikelUebersicht;

  //----------------------------------------------------------------------------

  protected
    procedure WndProc(var rcMessage: TMessage); override;

  //----------------------------------------------------------------------------

  public
    function ShowModal(var obAnbieterListe: TCaoPersonenListe;
                       var obArtikelListe : TCaoArtikelListe;
                       var obBoersenInfo  : TCaoBoersenInfo): Integer; reintroduce;

  //----------------------------------------------------------------------------

  end; // TCaDlgArtikelUebersicht

//------------------------------------------------------------------------------

var
  CaDlgArtikelUebersicht: TCaDlgArtikelUebersicht;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.FormShow(Sender: TObject);
begin
  inherited;
  m_FrmAnbieterUebersicht.ShowFrame(Self.Handle, m_obAnbieterListe);
  m_FrmArtikelUebersicht.ShowFrame(m_obArtikelListe, m_obBoersenInfo);
  PrvUpdateArtikelUebersicht;
end; // TCaDlgArtikelUebersicht.FormShow

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.PrvSetArtikelStatus;
begin
  m_FrmArtikelUebersicht.Enabled := m_FrmAnbieterUebersicht.IsAnbieterSelected;
end; // TCaDlgArtikelUebersicht.PrvSetArtikelStatus

//------------------------------------------------------------------------------

function TCaDlgArtikelUebersicht.ShowModal(var obAnbieterListe: TCaoPersonenListe;
                                           var obArtikelListe : TCaoArtikelListe;
                                           var obBoersenInfo  : TCaoBoersenInfo)
                                           : Integer;
begin
  m_obArtikelListe  := obArtikelListe;
  m_obAnbieterListe := obAnbieterListe;
  m_obBoersenInfo   := obBoersenInfo;
  Result := inherited ShowModal;
end; // TCaDlgArtikelUebersicht.ShowModal

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.FormCreate(Sender: TObject);
begin
  inherited;
  m_FrmAnbieterUebersicht.CreateFrame(m_obAnbieterListe);
  m_FrmArtikelUebersicht.CreateFrame;
end; // TCaDlgArtikelUebersicht.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.FormDestroy(Sender: TObject);
begin
  m_FrmAnbieterUebersicht.DestroyFrame;
  m_FrmArtikelUebersicht.DestroyFrame;
  inherited;
end; // TCaDlgArtikelUebersicht

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.BtnNeuClick(Sender: TObject);
begin
  inherited;
  m_FrmArtikelUebersicht.ActArtikelErfassenExecute(Sender);
end; // TCaDlgArtikelUebersicht.BtnNeuClick

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.BtnKopierenClick(Sender: TObject);
begin
  inherited;
  m_FrmArtikelUebersicht.ActArtikelKopierenExecute(Sender);
end; // TCaDlgArtikelUebersicht.BtnKopierenClick(Sender: TObject)

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.BtnBearbeitenClick(Sender: TObject);
begin
  inherited;
  m_FrmArtikelUebersicht.ActArtikelBearbeitenExecute(Sender);
end; // TCaDlgArtikelUebersicht.BtnBearbeitenClick

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.BtnLoeschenClick(Sender: TObject);
begin
  inherited;
  m_FrmArtikelUebersicht.ActArtikelLoeschenExecute(Sender);
end; // TCaDlgArtikelUebersicht.BtnLoeschenClick

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.FormClose(Sender: TObject;
                                            var Action: TCloseAction);
begin
  inherited;
  m_FrmArtikelUebersicht.CloseFrame;
end; // TCaDlgArtikelUebersicht.FormClose

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.WndProc(var rcMessage: TMessage);
(*
  In der WndProc werden die Windows-Messages behandelt. Hier wird die Message
  abgefangen, die sagt, dass sich die Selektion in der Anbieterbersicht
  gendert hat.
*)
begin
  case rcMessage.Msg of
    wm_UpdateFrmAnbieterUebersicht : PrvUpdateArtikelUebersicht;
  else inherited;
  end; // case
end; // TCaDlgArtikelUebersicht.WndProc

//------------------------------------------------------------------------------

procedure TCaDlgArtikelUebersicht.PrvUpdateArtikelUebersicht;
(*
  Wurde einen Person selektiert, so muss das Artikelbersicht-Frame neu
  initialisiert werden.
*)
begin
  // Die selektierte Person vom Personenbersicht-Frame zum Artikelbersicht-
  // Frame bergeben
  m_FrmArtikelUebersicht.SelectedPerson := m_FrmAnbieterUebersicht.SelectedPerson;
  // Setzen des Groupboxtitels
  if m_FrmAnbieterUebersicht.IsAnbieterSelected then begin
    m_GrpArtikel.Caption := 'Artikel von ' + m_FrmAnbieterUebersicht.SelectedPerson.sInitialen;
  end // if
  else begin
    m_GrpArtikel.Caption := c_sMeldungKeinAnbieter;
  end; // else
  PrvSetArtikelStatus;
  m_FrmArtikelUebersicht.UpdateFrame;
end; // TCaDlgArtikelUebersicht.PrvUpdateArtikelUebersicht

//------------------------------------------------------------------------------

end. // CadArtikelUebersicht
